!Object constantsFor: 'Geos Libraries'!

geosLIB63 'SYSTEM\security'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

settingsControlChangePinCodeRequest 27648!
settingsControlChangePinCodeRequestApproved 27649!
settingsControlPinCodeRequestChanged 27650!
settingsControlChangeLockTimeOut 27651!
settingsControlChangeLockTimeOutApproved 27652!
settingsControlLockTimeOutChanged 27653!
settingsControlChangeSecurityLevel 27654!
settingsControlChangeSecurityLevelApproved 27655!
settingsControlChangePinCode 27656!
settingsControlChangePinCodeApproved 27657!
settingsControlChangeLockCode 27658!
settingsControlChangeLockCodeApproved 27659!
settingsControlChangeNetworkPassword 27660!
settingsControlChangeNetworkPasswordApproved 27661!
settingsControlChangePin2Code 27662!
settingsControlChangePin2CodeApproved 27663!
!

!Geos class methodsFor: 'library calls'!

SecurityEnterLockMode
	"void pascal SecurityEnterLockMode(void) in security.goh"
	^GEOS call: #[63 0 6 0]!

SecurityDoPasswordDialog: code with: notifyObj with: notifyMsg
	"Boolean pascal SecurityDoPasswordDialog(SecurityCodeType code, optr notifyObj, word notifyMsg) in security.goh"
	^GEOS call: code with: notifyObj with: notifyMsg with: #[63 0 8 1 2 1 4]!

SecurityCheckCellPhoneMediaAvailable
	"Boolean pascal SecurityCheckCellPhoneMediaAvailable(void) in security.goh"
	^GEOS call: #[63 0 7 4]!

SecurityTryToMakeCellPhoneMediaAvailable
	"CellPhoneMediaStatus pascal SecurityTryToMakeCellPhoneMediaAvailable(void) in security.goh"
	^GEOS call: #[63 0 9 1]!

SecurityGetLockTimeOutTime
	"word pascal SecurityGetLockTimeOutTime(void) in security.goh"
	^GEOS call: #[63 0 10 1]!

SecurityCheckSIMCardAndPhone
	"word pascal SecurityCheckSIMCardAndPhone(void) in security.goh"
	^GEOS call: #[63 0 15 1]!

SecuritySuspendAutoLock
	"void pascal SecuritySuspendAutoLock(void) in security.goh"
	^GEOS call: #[63 0 16 0]!

SecurityResumeAutoLock
	"void pascal SecurityResumeAutoLock(void) in security.goh"
	^GEOS call: #[63 0 17 0]!

SecurityGetSIMAndPhoneStatus: simCardStatus
	"Boolean pascal SecurityGetSIMAndPhoneStatus(SIMCardStatusType *simCardStatus) in security.goh"
	^GEOS call: simCardStatus with: #[63 0 20 3 4]!

SecurityGetFDNStatus
	"Boolean pascal SecurityGetFDNStatus(void) in security.goh"
	^GEOS call: #[63 0 22 4]!

SecurityGetLockStatus
	"Boolean pascal SecurityGetLockStatus(void) in security.goh"
	^GEOS call: #[63 0 24 4]!

!

GenControl subclass: #SecuritySettingsControl
	instanceVariableNames: ''
	classVariableNames: ''!

!SecuritySettingsControl comment!
Library security, file security.goh! !

!SecuritySettingsControl class methodsFor: 'library linkage'!

library
	^63!

entry
	^0!
!

!SecuritySettingsControl methodsFor: 'Geos instance variables'!

!

!SecuritySettingsControl methodsFor: 'Geos vardata'!

!

!SecuritySettingsControl methodsFor: 'Geos messages'!

settingsControlChangePinCodeRequest
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN_CODE_REQUEST()"
	^self geosMessage: #[108 0 2 0 0]!

settingsControlChangePinCodeRequestApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN_CODE_REQUEST_APPROVED()"
	^self geosMessage: #[108 1 2 0 0]!

settingsControlPinCodeRequestChanged
	"@message void MSG_SECURITY_SETTINGS_CONTROL_PIN_CODE_REQUEST_CHANGED()"
	^self geosMessage: #[108 2 2 0 0]!

settingsControlChangeLockTimeOut
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_LOCK_TIME_OUT()"
	^self geosMessage: #[108 3 2 0 0]!

settingsControlChangeLockTimeOutApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_LOCK_TIME_OUT_APPROVED()"
	^self geosMessage: #[108 4 2 0 0]!

settingsControlLockTimeOutChanged
	"@message void MSG_SECURITY_SETTINGS_CONTROL_LOCK_TIME_OUT_CHANGED()"
	^self geosMessage: #[108 5 2 0 0]!

settingsControlChangeSecurityLevel
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_SECURITY_LEVEL()"
	^self geosMessage: #[108 6 2 0 0]!

settingsControlChangeSecurityLevelApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_SECURITY_LEVEL_APPROVED()"
	^self geosMessage: #[108 7 2 0 0]!

settingsControlChangePinCode
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN_CODE()"
	^self geosMessage: #[108 8 2 0 0]!

settingsControlChangePinCodeApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN_CODE_APPROVED()"
	^self geosMessage: #[108 9 2 0 0]!

settingsControlChangeLockCode
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_LOCK_CODE()"
	^self geosMessage: #[108 10 2 0 0]!

settingsControlChangeLockCodeApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_LOCK_CODE_APPROVED()"
	^self geosMessage: #[108 11 2 0 0]!

settingsControlChangeNetworkPassword
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_NETWORK_PASSWORD()"
	^self geosMessage: #[108 12 2 0 0]!

settingsControlChangeNetworkPasswordApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_NETWORK_PASSWORD_APPROVED()"
	^self geosMessage: #[108 13 2 0 0]!

settingsControlChangePin2Code
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN2_CODE()"
	^self geosMessage: #[108 14 2 0 0]!

settingsControlChangePin2CodeApproved
	"@message void MSG_SECURITY_SETTINGS_CONTROL_CHANGE_PIN2_CODE_APPROVED()"
	^self geosMessage: #[108 15 2 0 0]!

!

